module net.BurtonRadons.dig.common.event;

/** An event sent to a @a Dispatcher. */

struct Event
{
    int x; /**< X position of mouse in client-relative coordinates. */
    int y; /**< Y position of mouse in client-relative coordinates. */
    int deltax; /**< Cursor delta from previous location, or zero. */
    int deltay; /**< Cursor delta from previous location, or zero. */
    bit control; /**< Control key is down */
    bit lbutton; /**< Left mouse button is down */
    bit mbutton; /**< Middle mouse button is down */
    bit rbutton; /**< Right mouse button is down */
    bit shift; /**< Shift key is down */
    
    int left; /**< For the onPaint event, the left bound for the update region. */
    int top; /**< For the onPaint event, the top bound for the update region. */
    int right; /**< For the onPaint event, the right bound for the update region, inclusive. */
    int bottom; /**< For the onPaint event, the bottom bound for the update region, inclusive. */

    float wheel;
        /**< For the onMouseWheel event, the number of units that the
           * wheel has been spun.  Positive for spinning it
           * away from the user.  Negative for spinning it towards
           * the user.
           */

/* Scroll event fields. */

    /** Indicates the user's scrolling request. */
    enum Scroll
    {
        Bottom, /**< Scrolls to the bottom or right. */
        End, /**< No longer scrolling. */
        LineDown, /**< Scrolls one line down or right. */
        LineUp, /**< Scrolls one line up or left. */
        PageDown, /**< Scrolls one page down or right. */
        PageUp, /**< Scrolls one page up or left. */
        Drop, /**< The scroll box has been dragged and is now released. */
        Track, /**< The scroll box is being dragged. */
        Top, /**< Scrolls to the top or left. */
    };

    Scroll scrollType; /**< Type of the scrolling request. */
    int scrollPoint; /**< Current scrolling point. */
    int scrollDest; /**< The current scroll point with some good default changes according to the scrollType. */

/* Key event fields. */

    char [] keyCode;
    /**< Relevant key name for a keyDown event, or the character for the
         key in a char event.  For a keyDown event, it can be one of the
         following:

         <ul>
         <li> "BackSpace".
         <li> "Return"; return/enter key.
         <li> "Shift"; either shift key.
         <li> "Space".
         <li> "Control"; either control key.
         <li> "Delete".
         <li> "Insert".
         <li> "Tab".
         <li> "Escape".
        
         <li> "Pause".
         <li> "NumLock"; numeric keypad lock.
         <li> "CapsLock".
         <li> "ScrollLock".
        
         <li> "Down"; down arrow key.
         <li> "Left"; left arrow key.
         <li> "Right"; right arrow key.
         <li> "Up"; up arrow key.

         <li> "Home", "End", "PageUp", "PageDown".

         <li> "A", "B", ... "Z".
         <li> "0", "1", ... "9".
         <li> "NumPad0", "NumPad1", ... "NumPad9".

         <li> "Slash"; numeric pad slash.
         <li> "Asterisk"; numeric pad asterisk.
         <li> "Dash"; numeric pad dash.
         <li> "Plus"; numeric pad plus.
         <li> "Period"; numeric pad period.
         <li> "NoNumLock5"; numeric pad 5 when numeric lock is off.

         <li> "F1", "F2", ... "F24".
         </ul>
       */

    int keyRepeat; /**< Number of times the keystroke is auto-repeated. */
    bit keyPrevious; /**< Previous key state; true if it was down, false if it was up. */
}
